<?php
#require_once( "/opt/TrendMicro/DTAS/ManagementServer/bin/common.php" ) ;

class CommonUtility {
    ########################################
    # description:
    #     Check if specified ip is valid.
    #
    # return:
    #     true  : valid
    #     false : invalid
    #
    # example:
    #     require_once( "CommonUtility.class.php" ) ;
    #     $result = CommonUtility::isIpValid( "10.1.1.1" ) ;
    #     var_dump( $result ) ;
    ########################################
    static function isIpValid( $ip ) {
        
        # chek: 4 segments
        $ipArray = explode( ".", $ip ) ;
        if( count( $ipArray ) != 4 ) {
            return false ;
        }
        
        # check range 0~255 for each segment
        foreach( $ipArray as $item ) {
            if( $item < 0 or $item > 255 ) {
                return false ;
            }
        }

        # check segment 1: should be greater than 0
        if( $ipArray[ 0 ] < 1 ) {
            return false ;
        }
        
        # check special case: 0.0.0.0 (should be reject)
        # .... done in "check segment 1: should be greater than 0"
        return true ;
    }
    
    static function isIpPingable( $ip ) {
        $command = "/bin/ping -c 1 '$ip'" ;
        
        $retArray = self::executeCommand( $command ) ;
        if( $retArray[ "retValue" ] == 0 ) {
            return true ;
        }
        return false ;
    }
    
    static function isIpSshable( $ip, $port = 22  ) {
        if( ! ssh2_connect( $ip, $port ) ) {
            return false ;
        }
        return true ;
    }
    
    static function signalIgnore() {
        pcntl_signal( SIGHUP,  SIG_IGN ) ;
        pcntl_signal( SIGINT,  SIG_IGN ) ;
        pcntl_signal( SIGTERM, SIG_IGN ) ;
    }
    
    static function signalDefault() {
        pcntl_signal( SIGHUP,  SIG_DFL ) ;
        pcntl_signal( SIGINT,  SIG_DFL ) ;
        pcntl_signal( SIGTERM, SIG_DFL ) ;
    }
    
    const pattern_escape_shell_char = <<<heredoc
[\'\"]
heredoc;

    static public function mask_confidential_list($list, $mask_key_list) {
        $mask_list = $list;
        foreach($list as $key => $val) {
            if(!in_array($key, $mask_key_list)) continue;
            $mask_list[$key]= '<hidden>';
        }
        return $mask_list;
    }

    static public function mask_confidential_option($msg, $option) {
        $filter_pattern = sprintf("/(?P<option>%s%s?\s+)(?P<hidden>\S+)/", $option, CommonUtility::pattern_escape_shell_char);
        $ret = preg_replace($filter_pattern, '$1<hidden>', $msg);
        if(empty($ret)) throw new Exception("Cannot mask confidential option value by message: $msg, option : $option");
        return $ret;
    }

    static public function mask_confidential_option_list($msg, $option_list) {
        $processed_msg = $msg;
        foreach($option_list as $option) {
            $processed_msg = CommonUtility::mask_confidential_option($processed_msg, $option);
        }
        return $processed_msg;
    }

    static function debug_print( $msg ) {
        if( file_exists( "/opt/TrendMicro/DTAS/debug_disable" ) == true ) {
            return true ;
        }
        
        $call_stack = debug_backtrace() ;
        
        # index 0 means the latest caller's information
        $filename = basename( $call_stack[ 0 ][ "file" ] );
        $lineno   =           $call_stack[ 0 ][ "line" ] ;

        openlog( "[$filename($lineno)]", LOG_NDELAY, LOG_LOCAL0 ) ;
        syslog( LOG_INFO, $msg ) ;
        closelog() ;
        // echo "echo ~ [$filename($lineno)]: " . $msg . "\n" ;
    }

    static function executeCommand( $command, $confidential_option_list = array() ) {
        $mask_command = CommonUtility::mask_confidential_option_list($command, $confidential_option_list);
        dprint( 0, LOG_DEBUG, "command='$mask_command'" ) ;
        
        unset( $retMsgArray ) ;
        exec( $command . " 2>&1", $retMsgArray, $retValue ) ;

        return array( $retValue, $retMsgArray ) ;
    }
    
    static function runProgramAtMs( $argv, $confidential_option_list = array( '--passwd', '--password', '--username' ) ) {
        $program    = $argv[ 'program' ] ;
        $arguments  = isset( $argv[ 'arguments' ] ) ? $argv[ 'arguments' ] : array() ;
        $outputPath = isset( $argv[ 'pipe_to' ] )   ? $argv[ 'pipe_to' ]   : null ;
        $isEscape   = isset( $argv[ 'escape' ] )    ? $argv[ 'escape' ]    : 1 ;
        
        if( $isEscape == 1 ) {
            for( $i = 0 ; $i < count( $arguments ); $i++ ) {
                $arguments[ $i ] = escapeshellarg( $arguments[ $i ] ) ;
            }
        }
        
        if( $outputPath !== null ) {
            # array_push( $arguments, "\"\\\"> $outputPath\\\"\"" ) ;
            array_push( $arguments, "> '$outputPath'" ) ;
        }
        
        # execute
        $resultArguments = join( " ", $arguments ) ;
        return self::executeCommand( $program . " " . $resultArguments, $confidential_option_list ) ;
    }

    static function stepRunProgramAtMs( $argv, $confidential_option_list = array( '--passwd', '--password', '--username')) {
        $stepName = isset( $argv[ "stepname" ] ) ? $argv[ "stepname" ] : "RunProgramAtMs" ;
        
        # composing debug message
        $msg = $stepName . ": " . escapeshellarg( $argv[ 'program' ] ) ;
        $arguments_array = isset( $argv[ 'arguments' ] ) ? $argv[ 'arguments' ] : array() ;
        foreach( $arguments_array as $argument ) {
            $msg .=  " " . escapeshellarg( $argument ) ;
        }
        $msg = self::mask_confidential_option_list( $msg, $confidential_option_list ) ;
        dprint( 0, LOG_DEBUG, $msg ) ;
        
        # launching
        $ret_array = self::runProgramAtMs( $argv, $confidential_option_list ) ;
        
        # verify return code
        $retCode = $ret_array[ 0 ] ;
        $msg     = join( "\n", $ret_array[ 1 ] ) ;
        if( $retCode != 0 ) {
            $errMsg = "${stepName}Fail: ret='$retCode', msg='$msg'" ;
            dprint( 0, LOG_ERR, $errMsg ) ;
            throw new Exception( $errMsg ) ;
        }
        dprint( 0, LOG_DEBUG, "${stepName}Pass: msg='$msg'" ) ;
        return $ret_array ;
    }

    static function retry( $funcName, $argv ) {
        $retryCount    = 0 ;
        $retryCountMax = isset( $argv[ "retry_max" ] )      ? $argv[ "retry_max" ]      : 3 ;
        $retryInterval = isset( $argv[ "retry_interval" ] ) ? $argv[ "retry_interval" ] : 30 ;
        $stepname      = isset( $argv[ "stepname" ] )       ? $argv[ "stepname" ]       : "retry" ;
        
        while( true ) {
            try {
                $result = call_user_func( $funcName, $argv ) ;
                if( $result == true ) {
                    break ;
                }
            }
            catch( Exception $e ) {
                $msg = "[" . basename( $e -> getFile() ) . "(" . $e -> getLine() . ")]: " . $e -> getMessage() . "\n" ;
                dprint( 0, LOG_WARNING, $msg ) ;
            }
            
            dprint( 0, LOG_WARNING, "Sleep $retryInterval seconds for next try ($retryCount/$retryCountMax)..." ) ;
            sleep( $retryInterval ) ;
            
            $retryCount++ ;
            if( $retryCount > $retryCountMax ) {
                throw new Exception( "FailLaunchFunction(ExceedRetryCount): function='$funcName', msg='$msg', retryCount='$retryCountMax'" ) ;
            }
        }
    }
}


if( realpath( $_SERVER[ "SCRIPT_NAME" ] ) == realpath( __FILE__ ) ) {
    try {
        #require_once( "CommonUtility.class.php" ) ;
        $ipArray = array(
            "10.1.1.1",
            "10.1.1.-1",
            "10.1.256.1",
            "0.1.1.1",
            "0.0.0.0" ) ;
            
        foreach( $ipArray as $ip ) {
            $result = CommonUtility::isIpValid( $ip ) ;
            var_dump( $result ) ;
        }
    }
    
    catch ( Exception $e ) {
        echo "[" . $e -> getFile() . "(" . $e -> getLine() . ")]: " . $e -> getMessage() . "\n" ;
    }
}


